function Err=HMF(theta) 

global N delta s r pi p P phi c z gamma

R=1/(1+r);
one(1:N,1)=1;
for i=1:N
    f(i)=phi*theta(i)^.5;
    rho(i)=f(i)/theta(i);
    for ip=1:N
        UV(i,ip)=R*pi(i,ip)*f(i);
        UU(i,ip)=R*pi(i,ip)*(1-f(i));
        VU(i,ip)=R*pi(i,ip)*s;
        VV(i,ip)=R*pi(i,ip)*(1-s);
        WV(i,ip)=-(1-delta)*R*pi(i,ip);
    end
end

A=[eye(N)-UU,-UV,-UV,zeros(N);  %  U
    -VU,eye(N)-VV,zeros(N,2*N);  %  V
    -delta*eye(N),eye(N)+WV,eye(N),WV;  %  W
    zeros(N,2*N),-WV,-eye(N)];  %  Wp
a=[z*one;zeros(N,1);(1-delta)*z*one;-P+(1-delta)*R*pi*P-(1-delta)*gamma*one];
X=A^(-1)*a;
U=X(1:N);
V=X(N+1:2*N);
W=X(2*N+1:3*N);
Wp=X(3*N+1:4*N);

%  Zero profit

for i=1:N
    Err(i)=rho(i)*(P(i)-W(i))-c;
end
 
save HMF U V W Wp